/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.valueobject;

import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Version
implements Comparable<Version> {
    private final int _major;
    private final int _minor;
    private final int _micro;
    private final String _qualifier;

    public Version(int major, int minor, int micro, @Nullable String qualifier) {
        this._major = major;
        this._minor = minor;
        this._micro = micro;
        this._qualifier = qualifier != null ? qualifier : "";
    }

    public int getMajor() {
        return this._major;
    }

    public int getMinor() {
        return this._minor;
    }

    public int getMicro() {
        return this._micro;
    }

    public String getQualifier() {
        return this._qualifier;
    }

    @Override
    public int compareTo(Version o) {
        int result = this.getMajor() - o.getMajor();
        if (result == 0) {
            result = this.getMinor() - o.getMinor();
        }
        if (result == 0) {
            result = this.getMicro() - o.getMicro();
        }
        if (result == 0) {
            result = this.getQualifier().compareTo(o.getQualifier());
        }
        return result;
    }

    public String toString() {
        return this._major + "." + this._minor + "." + this._micro + (this._qualifier.length() > 0 ? "." + this._qualifier : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        if (this._major != version._major) {
            return false;
        }
        if (this._micro != version._micro) {
            return false;
        }
        if (this._minor != version._minor) {
            return false;
        }
        return this._qualifier.equals(version._qualifier);
    }

    public int hashCode() {
        int result = this._major;
        result = 31 * result + this._minor;
        result = 31 * result + this._micro;
        result = 31 * result + this._qualifier.hashCode();
        return result;
    }
}

