/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.valueobject;

import org.jetbrains.annotations.NotNull;
import org.osmorc.valueobject.Version;

public class VersionRange {
    private final Boundary _floorBoundary;
    private final Version _floor;
    private final Version _ceiling;
    private final Boundary _ceilingBoundary;

    public VersionRange(@NotNull Boundary floorBoundary, @NotNull Version floor, @NotNull Version ceiling, @NotNull Boundary ceilingBoundary) {
        if (floorBoundary == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/valueobject/VersionRange.<init> must not be null");
        }
        if (floor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/valueobject/VersionRange.<init> must not be null");
        }
        if (ceiling == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/osmorc/valueobject/VersionRange.<init> must not be null");
        }
        if (ceilingBoundary == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/osmorc/valueobject/VersionRange.<init> must not be null");
        }
        this._floorBoundary = floorBoundary;
        this._floor = floor;
        this._ceiling = ceiling;
        this._ceilingBoundary = ceilingBoundary;
    }

    public VersionRange(@NotNull Version atleast) {
        if (atleast == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/valueobject/VersionRange.<init> must not be null");
        }
        this._floor = atleast;
        this._floorBoundary = Boundary.INCLUSIVE;
        this._ceiling = null;
        this._ceilingBoundary = null;
    }

    public boolean contains(@NotNull Version version) {
        if (version == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/valueobject/VersionRange.contains must not be null");
        }
        return this.checkFloor(version) && this.checkCeiling(version);
    }

    private boolean checkFloor(@NotNull Version version) {
        if (version == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/valueobject/VersionRange.checkFloor must not be null");
        }
        int comparison = version.compareTo(this._floor);
        return this._floorBoundary == Boundary.INCLUSIVE ? comparison >= 0 : comparison > 0;
    }

    private boolean checkCeiling(@NotNull Version version) {
        if (version == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/valueobject/VersionRange.checkCeiling must not be null");
        }
        if (this._ceiling != null) {
            int comparison = version.compareTo(this._ceiling);
            return this._ceilingBoundary == Boundary.INCLUSIVE ? comparison <= 0 : comparison < 0;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Boundary {
        INCLUSIVE,
        EXCLUSIVE;

    }
}

