/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.bundlor.support.contributors;

import com.springsource.bundlor.support.contributors.AbstractXmlDocumentArtefactAnalyser;
import com.springsource.bundlor.support.partialmanifest.PartialManifest;
import com.springsource.bundlor.util.ClassNameUtils;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.springframework.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractXmlConfigurationArtifactAnalyzer
extends AbstractXmlDocumentArtefactAnalyser {
    public AbstractXmlConfigurationArtifactAnalyzer() {
        super(true);
    }

    protected abstract String getClassAttributesXPathExpression();

    protected abstract String getClassValueXPathExpression();

    protected abstract String getPackageXPathExpression();

    protected abstract Map<String, String> getNamespaceMapping();

    @Override
    protected final void analyse(Document doc, String artefactName, PartialManifest partialManifest) throws Exception {
        this.analyzeClassAttributes(doc, partialManifest);
        this.analyzeClassValues(doc, partialManifest);
        this.analyzePackageAttributes(doc, partialManifest);
    }

    private void analyzeClassAttributes(Document doc, PartialManifest partialManifest) throws XPathExpressionException {
        String expressionString = this.getClassAttributesXPathExpression();
        if (expressionString != null) {
            NodeList nodes = (NodeList)this.getXPathExpression(expressionString).evaluate(doc, XPathConstants.NODESET);
            int i = 0;
            while (i < nodes.getLength()) {
                Attr classAttribute = (Attr)nodes.item(i);
                if (classAttribute.getValue().contains(",")) {
                    String[] stringArray = StringUtils.tokenizeToStringArray(classAttribute.getValue(), ", ");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String clazz = stringArray[n2];
                        String candidateType = clazz.trim();
                        if (ClassNameUtils.isValidFqn(candidateType)) {
                            partialManifest.recordReferencedType(candidateType);
                        }
                        ++n2;
                    }
                } else {
                    String candidateType = classAttribute.getValue().trim();
                    if (ClassNameUtils.isValidFqn(candidateType)) {
                        partialManifest.recordReferencedType(candidateType);
                    }
                }
                ++i;
            }
        }
    }

    private void analyzeClassValues(Document doc, PartialManifest partialManifest) throws XPathExpressionException {
        String expressionString = this.getClassValueXPathExpression();
        if (expressionString != null) {
            NodeList nodes = (NodeList)this.getXPathExpression(expressionString).evaluate(doc, XPathConstants.NODESET);
            int i = 0;
            while (i < nodes.getLength()) {
                Node classNode = nodes.item(i);
                if (classNode.getTextContent().contains(",")) {
                    String[] stringArray = StringUtils.tokenizeToStringArray(classNode.getTextContent(), ", ");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String clazz = stringArray[n2];
                        String candidateType = clazz.trim();
                        if (ClassNameUtils.isValidFqn(candidateType)) {
                            partialManifest.recordReferencedType(candidateType);
                        }
                        ++n2;
                    }
                } else {
                    String candidateType = classNode.getTextContent().trim();
                    if (ClassNameUtils.isValidFqn(candidateType)) {
                        partialManifest.recordReferencedType(candidateType);
                    }
                }
                ++i;
            }
        }
    }

    private void analyzePackageAttributes(Document doc, PartialManifest partialManifest) throws XPathExpressionException {
        String expressionString = this.getPackageXPathExpression();
        if (expressionString != null) {
            NodeList nodes = (NodeList)this.getXPathExpression(expressionString).evaluate(doc, XPathConstants.NODESET);
            int i = 0;
            while (i < nodes.getLength()) {
                Attr packageAttribute = (Attr)nodes.item(i);
                if (packageAttribute.getValue().contains(",")) {
                    String[] stringArray = StringUtils.tokenizeToStringArray(packageAttribute.getValue(), ", ");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String packageName = stringArray[n2];
                        String candidatePackage = packageName.trim();
                        if (ClassNameUtils.isValidFqn(candidatePackage)) {
                            partialManifest.recordReferencedPackage(candidatePackage);
                        }
                        ++n2;
                    }
                } else {
                    String candidatePackage = packageAttribute.getValue().trim();
                    if (ClassNameUtils.isValidFqn(candidatePackage)) {
                        partialManifest.recordReferencedPackage(candidatePackage);
                    }
                }
                ++i;
            }
        }
    }

    private final XPathExpression getXPathExpression(String expressionString) throws XPathExpressionException {
        XPathFactory newInstance = XPathFactory.newInstance();
        XPath xpath = newInstance.newXPath();
        xpath.setNamespaceContext(this.getNamespaceContext());
        return xpath.compile(expressionString);
    }

    private final XmlConfigurationNamespaceContext getNamespaceContext() {
        return new XmlConfigurationNamespaceContext(this.getNamespaceMapping());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class XmlConfigurationNamespaceContext
    implements NamespaceContext {
        private final Map<String, String> namespaceMapping;

        public XmlConfigurationNamespaceContext(Map<String, String> namespaceMapping) {
            this.namespaceMapping = namespaceMapping;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (this.namespaceMapping.containsKey(prefix)) {
                return this.namespaceMapping.get(prefix);
            }
            return "";
        }

        @Override
        public String getPrefix(String namespace) {
            if (this.namespaceMapping.containsValue(namespace)) {
                for (Map.Entry<String, String> entry : this.namespaceMapping.entrySet()) {
                    if (!namespace.equals(entry.getValue())) continue;
                    return entry.getKey();
                }
            }
            return null;
        }

        public Iterator getPrefixes(String namespace) {
            return null;
        }
    }
}

