/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.bundlor.util;

import com.springsource.bundlor.util.SimpleManifestContents;
import com.springsource.bundlor.util.SimpleParserLogger;
import com.springsource.util.osgi.manifest.BundleManifest;
import com.springsource.util.osgi.manifest.BundleManifestFactory;
import com.springsource.util.osgi.manifest.parse.ParserLogger;
import com.springsource.util.parser.manifest.ManifestContents;
import com.springsource.util.parser.manifest.ManifestProblem;
import com.springsource.util.parser.manifest.RecoveringManifestParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;

public final class BundleManifestUtils {
    public static BundleManifest createBundleManifest(ManifestContents manifest) {
        return BundleManifestFactory.createBundleManifest((ManifestContents)manifest, (ParserLogger)new SimpleParserLogger());
    }

    public static ManifestContents getManifest(File manifestFile) {
        if (manifestFile == null || !manifestFile.exists()) {
            return new SimpleManifestContents();
        }
        try {
            return BundleManifestUtils.getManifest(new FileReader(manifestFile));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ManifestContents getManifest(Reader reader) {
        ManifestContents manifestContents;
        RecoveringManifestParser parser = new RecoveringManifestParser();
        try {
            ManifestContents manifest = parser.parse(reader);
            if (parser.foundProblems()) {
                Iterator iterator = parser.getProblems().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        throw new RuntimeException("There was a problem with the manifest");
                    }
                    ManifestProblem problem = (ManifestProblem)iterator.next();
                    System.err.println(problem.toStringWithContext());
                    System.err.println();
                }
            }
            manifestContents = manifest;
            if (reader == null) return manifestContents;
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            reader.close();
            return manifestContents;
        }
        catch (IOException iOException) {}
        return manifestContents;
    }
}

