/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner.platform.equinox.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.runner.platform.BundleReference;
import org.ops4j.pax.runner.platform.Configuration;
import org.ops4j.pax.runner.platform.PlatformBuilder;
import org.ops4j.pax.runner.platform.PlatformContext;
import org.ops4j.pax.runner.platform.PlatformException;
import org.ops4j.util.collections.PropertiesWriter;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquinoxPlatformBuilder
implements PlatformBuilder {
    private static final Log LOGGER = LogFactory.getLog(EquinoxPlatformBuilder.class);
    private static final String PROVIDER_NAME = "equinox";
    private static final String ARG_CONFIGURATION = "-configuration";
    private static final String ARG_CONSOLE = "-console";
    private static final String ARG_DEBUG = "-debug";
    private static final String PROP_INSTALL_AREA = "osgi.install.area";
    private static final String PROP_SYSPATH = "osgi.syspath";
    private static final String MAIN_CLASS_NAME = "org.eclipse.core.runtime.adaptor.EclipseStarter";
    private static final String CONFIG_DIRECTORY = "equinox";
    private static final String OPTIONS = ".options";
    private static final String CONFIG_INI = "config.ini";
    private static final String BOOT_DELEGATION_PACKAGES = "java.*";
    private final BundleContext m_bundleContext;
    private final String m_version;
    private static final String ECLIPSE_PRODUCT = "eclipse.product";
    private static final String ECLIPSE_APPLICATION = "eclipse.application";
    private static final String ECLIPSE_IGNORE_APP = "eclipse.ignoreApp";

    public EquinoxPlatformBuilder(BundleContext bundleContext, String version) {
        NullArgumentException.validateNotNull(bundleContext, "Bundle context");
        NullArgumentException.validateNotNull(version, "Version");
        this.m_bundleContext = bundleContext;
        this.m_version = version;
    }

    @Override
    public void prepare(PlatformContext context) throws PlatformException {
        NullArgumentException.validateNotNull(context, "Platform context");
        this.createConfigIniFile(context);
        this.createOptionsFile(context);
    }

    private void createConfigIniFile(PlatformContext context) throws PlatformException {
        List<BundleReference> bundles = context.getBundles();
        OutputStream os = null;
        try {
            Integer bundleStartLevel;
            Integer startLevel;
            Boolean usePersistedState;
            File configDirectory = new File(context.getWorkingDirectory(), "equinox");
            configDirectory.mkdirs();
            File configFile = new File(configDirectory, CONFIG_INI);
            configFile.createNewFile();
            LOGGER.debug("Create equinox configuration ini file [" + configFile + "]");
            Configuration configuration = context.getConfiguration();
            os = new FileOutputStream(configFile);
            PropertiesWriter writer = new PropertiesWriter(os);
            this.writeHeader(writer);
            writer.append("#############################");
            writer.append(" Equinox settings");
            writer.append("#############################");
            String[] vmOptions = context.getConfiguration().getVMOptions();
            if (!(this.contains(vmOptions, ECLIPSE_PRODUCT) || this.contains(vmOptions, ECLIPSE_APPLICATION) || this.contains(vmOptions, ECLIPSE_IGNORE_APP))) {
                writer.append(ECLIPSE_IGNORE_APP, "true");
            }
            writer.append(PROP_SYSPATH, context.getFilePathStrategy().normalizeAsPath(context.getWorkingDirectory()));
            Boolean startConsole = context.getConfiguration().startConsole();
            if (startConsole == null || !startConsole.booleanValue()) {
                writer.append("osgi.framework.activeThreadType", "normal");
            }
            if ((usePersistedState = configuration.usePersistedState()) != null && !usePersistedState.booleanValue()) {
                writer.append("osgi.clean", "true");
            }
            if ((startLevel = configuration.getStartLevel()) != null) {
                writer.append("osgi.startLevel", startLevel.toString());
            }
            if ((bundleStartLevel = configuration.getBundleStartLevel()) != null) {
                writer.append("osgi.bundles.defaultStartLevel", bundleStartLevel.toString());
            }
            writer.append("org.osgi.framework.executionenvironment", context.getExecutionEnvironment());
            StringBuilder bootDelegation = new StringBuilder();
            String bootDelegationOption = context.getConfiguration().getBootDelegation();
            if (bootDelegationOption != null) {
                bootDelegation.append(bootDelegationOption).append(",");
            }
            bootDelegation.append(BOOT_DELEGATION_PACKAGES);
            writer.append("org.osgi.framework.bootdelegation", bootDelegation.toString());
            writer.append("org.osgi.framework.system.packages", context.getSystemPackages());
            if (bundles != null && bundles.size() > 0) {
                writer.append();
                writer.append("#############################");
                writer.append(" Client bundles to install");
                writer.append("#############################");
                this.appendBundles(writer, bundles, context);
            }
            writer.append();
            writer.append("#############################");
            writer.append(" System properties");
            writer.append("#############################");
            this.appendProperties(writer, context.getProperties());
            writer.write();
        }
        catch (IOException e) {
            throw new PlatformException("Could not create equinox configuration file", e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    throw new PlatformException("Could not create equinox configuration file", e);
                }
            }
        }
    }

    private void createOptionsFile(PlatformContext context) throws PlatformException {
        OutputStream os = null;
        try {
            File configDirectory = new File(context.getWorkingDirectory(), "equinox");
            configDirectory.mkdirs();
            File configFile = new File(configDirectory, OPTIONS);
            configFile.createNewFile();
            Configuration configuration = context.getConfiguration();
            if (this.isOptionsFileNeeded(configuration).booleanValue()) {
                LOGGER.debug("Create equinox options file [" + configFile + "]");
                os = new FileOutputStream(configFile);
                PropertiesWriter writer = new PropertiesWriter(os);
                this.writeHeader(writer);
                Properties props = new Properties();
                writer.append("#############################");
                writer.append(" Equinox debug options");
                writer.append("#############################");
                props.setProperty("org.eclipse.osgi/trace/filename", "runtime.traces");
                props.setProperty("org.eclipse.osgi/debug/bundleTime", "false");
                props.setProperty("org.eclipse.osgi/defaultprofile/logsynchronously", "false");
                props.setProperty("org.eclipse.osgi/resolver/requires", "false");
                props.setProperty("org.eclipse.osgi/debug", "false");
                props.setProperty("org.eclipse.osgi/profile/benchmark", "false");
                props.setProperty("org.eclipse.osgi/defaultprofile/buffersize", "256");
                props.setProperty("org.eclipse.osgi/trace/activation", "false");
                props.setProperty("org.eclipse.osgi/debug/security", "false");
                props.setProperty("org.eclipse.osgi/resolver/wiring", "false");
                props.setProperty("org.eclipse.osgi/eclipseadaptor/debug/platformadmin/resolver", "false");
                props.setProperty("org.eclipse.osgi/debug/loader", "true");
                props.setProperty("org.eclipse.osgi/eclipseadaptor/debug", "false");
                props.setProperty("org.eclipse.osgi/debug/messageBundles", "false");
                props.setProperty("org.eclipse.osgi/debug/events", "false");
                props.setProperty("org.eclipse.osgi/resolver/debug", "false");
                props.setProperty("org.eclipse.osgi/profile/startup", "false");
                props.setProperty("org.eclipse.osgi/debug/startlevel", "false");
                props.setProperty("org.eclipse.osgi/debug/packageadmin", "false");
                props.setProperty("org.eclipse.osgi/resolver/grouping", "false");
                props.setProperty("org.eclipse.osgi/trace/classLoading", "false");
                props.setProperty("org.eclipse.osgi/eclipseadaptor/debug/platformadmin", "false");
                props.setProperty("org.eclipse.osgi/debug/filter", "false");
                props.setProperty("org.eclipse.osgi/monitor/activation", "false");
                props.setProperty("org.eclipse.osgi/resolver/generics", "false");
                props.setProperty("org.eclipse.osgi/debug/manifest", "false");
                props.setProperty("org.eclipse.osgi/debug/services", "false");
                props.setProperty("org.eclipse.osgi/eclipseadaptor/debug/location", "false");
                props.setProperty("org.eclipse.osgi/profile/impl", "org.eclipse.osgi.internal.profile.DefaultProfileLogger");
                props.setProperty("org.eclipse.osgi/eclipseadaptor/converter/debug", "false");
                props.setProperty("org.eclipse.osgi/profile/debug", "false");
                props.setProperty("org.eclipse.osgi/monitor/classes", "false");
                props.setProperty("org.eclipse.osgi/trace/filters", "trace.properties");
                props.setProperty("org.eclipse.osgi/resolver/cycles", "false");
                props.setProperty("org.eclipse.osgi/defaultprofile/logfilename", "");
                props.setProperty("org.eclipse.osgi/resolver/imports", "false");
                props.setProperty("org.eclipse.osgi/monitor/resources", "false");
                this.appendProperties(writer, props);
                writer.write();
            }
        }
        catch (IOException e) {
            throw new PlatformException("Could not create equinox debug options file", e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    throw new PlatformException("Could not create equinox debug options file", e);
                }
            }
        }
    }

    private Boolean isOptionsFileNeeded(Configuration configuration) {
        return configuration.isDebugClassLoading();
    }

    private void appendProperties(PropertiesWriter writer, Properties properties) {
        if (properties != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                writer.append(key, properties.getProperty(key));
            }
        }
    }

    private void appendBundles(PropertiesWriter writer, List<BundleReference> bundles, PlatformContext context) throws MalformedURLException, PlatformException {
        for (BundleReference reference : bundles) {
            Boolean shouldStart;
            URL url = reference.getURL();
            if (url == null) {
                throw new PlatformException("The file from bundle to install cannot be null");
            }
            StringBuilder builder = new StringBuilder();
            if ("file".equals(url.getProtocol())) {
                builder.append("reference:");
            }
            builder.append(context.getFilePathStrategy().normalizeAsUrl(url));
            Integer startLevel = reference.getStartLevel();
            if (startLevel != null) {
                builder.append("@").append(startLevel);
            }
            if ((shouldStart = reference.shouldStart()) != null && shouldStart.booleanValue()) {
                if (startLevel != null) {
                    builder.append(":");
                } else {
                    builder.append("@");
                }
                builder.append("start");
            }
            writer.append("osgi.bundles", builder.toString());
        }
    }

    private void writeHeader(PropertiesWriter writer) {
        writer.append("###############################################");
        writer.append("              ______  ________  __  __        #");
        writer.append("             / __  / /  __   / / / / /        #");
        writer.append("            /  ___/ /  __   / _\\ \\ _/         #");
        writer.append("           /  /    /  / /  / / _\\ \\           #");
        writer.append("          /__/    /__/ /__/ /_/ /_/           #");
        writer.append("                                              #");
        writer.append(" Pax Runner from OPS4J - http://www.ops4j.org #");
        writer.append("###############################################");
        writer.append();
    }

    @Override
    public String getMainClassName() {
        return MAIN_CLASS_NAME;
    }

    @Override
    public String[] getArguments(PlatformContext context) {
        NullArgumentException.validateNotNull(context, "Platform context");
        File workingDirectory = context.getWorkingDirectory();
        ArrayList<String> arguments = new ArrayList<String>();
        Boolean startConsole = context.getConfiguration().startConsole();
        if (startConsole != null && startConsole.booleanValue()) {
            arguments.add(ARG_CONSOLE);
        }
        arguments.add(ARG_CONFIGURATION);
        arguments.add(context.getFilePathStrategy().normalizeAsPath(new File(workingDirectory, "equinox")));
        if (this.isOptionsFileNeeded(context.getConfiguration()).booleanValue()) {
            arguments.add(ARG_DEBUG);
            arguments.add(context.getFilePathStrategy().normalizeAsPath(new File(new File(workingDirectory, "equinox"), OPTIONS)));
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    @Override
    public String[] getVMOptions(PlatformContext context) {
        NullArgumentException.validateNotNull(context, "Platform context");
        ArrayList<String> vmOptions = new ArrayList<String>();
        vmOptions.add("-Dosgi.install.area=" + context.getFilePathStrategy().normalizeAsPath(new File(context.getWorkingDirectory(), "equinox")));
        return vmOptions.toArray(new String[vmOptions.size()]);
    }

    @Override
    public InputStream getDefinition(Configuration configuration) throws IOException {
        String definitionFile = "META-INF/platform-equinox/definition-" + this.m_version + ".xml";
        URL url = this.m_bundleContext.getBundle().getResource(definitionFile);
        if (url == null) {
            throw new FileNotFoundException(definitionFile + " could not be found");
        }
        return url.openStream();
    }

    @Override
    public String getRequiredProfile(PlatformContext context) {
        return null;
    }

    public String toString() {
        return "Equinox " + this.m_version;
    }

    @Override
    public String getProviderName() {
        return "equinox";
    }

    @Override
    public String getProviderVersion() {
        return this.m_version;
    }

    private boolean contains(String[] haystack, String needle) {
        for (String s : haystack) {
            if (!s.contains(needle)) continue;
            return true;
        }
        return false;
    }
}

