package mcp250xx;

/*Generated by MPS Feb 12, 2006 3:12:55 PM */


import java.util.List;
import java.util.LinkedList;

public enum AcknowledgeMessageType {
  COMMAND_ACKNOWLEDGE_MESSAGE("Command acknowledge message", "1"),
  RECEIVE_OVERFLOW_MESSAGE("Receive overflow message", "0");

  public String myName;
  public String myValue;

 AcknowledgeMessageType(String name, String value) {
    this.myName = name;
    this.myValue = value;
  }

  public static List<AcknowledgeMessageType> getConstants() {
    List<AcknowledgeMessageType> list = new LinkedList<AcknowledgeMessageType>();
    list.add(AcknowledgeMessageType.COMMAND_ACKNOWLEDGE_MESSAGE);
    list.add(AcknowledgeMessageType.RECEIVE_OVERFLOW_MESSAGE);
    return list;
  }
  public static AcknowledgeMessageType getDefault() {
    return AcknowledgeMessageType.RECEIVE_OVERFLOW_MESSAGE;
  }
  public static AcknowledgeMessageType parseValue(String value) {
    if(value == null) {
      return AcknowledgeMessageType.getDefault();
    }
    if(value.equals(AcknowledgeMessageType.COMMAND_ACKNOWLEDGE_MESSAGE.getValueAsString())) {
      return AcknowledgeMessageType.COMMAND_ACKNOWLEDGE_MESSAGE;
    }
    if(value.equals(AcknowledgeMessageType.RECEIVE_OVERFLOW_MESSAGE.getValueAsString())) {
      return AcknowledgeMessageType.RECEIVE_OVERFLOW_MESSAGE;
    }
    return AcknowledgeMessageType.getDefault();
  }

  public String getName() {
    return this.myName;
  }
  public String getValueAsString() {
    return this.myValue;
  }
  public String getValue() {
    return this.myValue;
  }
}
