package mcp250xx;

/*Generated by MPS Feb 12, 2006 3:12:58 PM */


import java.util.List;
import java.util.LinkedList;

public enum AnalogAquisitionTime {
  TOSC_64("64 Tosc", 0),
  TOSC_64_2("2*(64 Tosc)", 1),
  TOSC_64_4("4*(64 Tosc)", 2),
  TOSC_64_8("8*(64 Tosc)", 3);

  public String myName;
  public int myValue;

 AnalogAquisitionTime(String name, int value) {
    this.myName = name;
    this.myValue = value;
  }

  public static List<AnalogAquisitionTime> getConstants() {
    List<AnalogAquisitionTime> list = new LinkedList<AnalogAquisitionTime>();
    list.add(AnalogAquisitionTime.TOSC_64);
    list.add(AnalogAquisitionTime.TOSC_64_2);
    list.add(AnalogAquisitionTime.TOSC_64_4);
    list.add(AnalogAquisitionTime.TOSC_64_8);
    return list;
  }
  public static AnalogAquisitionTime getDefault() {
    return AnalogAquisitionTime.TOSC_64;
  }
  public static AnalogAquisitionTime parseValue(String value) {
    if(value == null) {
      return AnalogAquisitionTime.getDefault();
    }
    if(value.equals(AnalogAquisitionTime.TOSC_64.getValueAsString())) {
      return AnalogAquisitionTime.TOSC_64;
    }
    if(value.equals(AnalogAquisitionTime.TOSC_64_2.getValueAsString())) {
      return AnalogAquisitionTime.TOSC_64_2;
    }
    if(value.equals(AnalogAquisitionTime.TOSC_64_4.getValueAsString())) {
      return AnalogAquisitionTime.TOSC_64_4;
    }
    if(value.equals(AnalogAquisitionTime.TOSC_64_8.getValueAsString())) {
      return AnalogAquisitionTime.TOSC_64_8;
    }
    return AnalogAquisitionTime.getDefault();
  }

  public String getName() {
    return this.myName;
  }
  public String getValueAsString() {
    return "" + this.myValue;
  }
  public int getValue() {
    return this.myValue;
  }
}
