package mcp250xx;

/*Generated by MPS Feb 12, 2006 3:12:55 PM */


import java.util.List;
import java.util.LinkedList;

public enum AutoSleepBehaviour {
  SLEEP_IF_BUS_IS_IDLE("Device will enter Sleep if bus is idle for at least 1408 bit times", 1),
  DO_NOT_ENTER_SLEEP_MODE("Device will NOT enter Sleep if bus is idle", 0);

  public String myName;
  public int myValue;

 AutoSleepBehaviour(String name, int value) {
    this.myName = name;
    this.myValue = value;
  }

  public static List<AutoSleepBehaviour> getConstants() {
    List<AutoSleepBehaviour> list = new LinkedList<AutoSleepBehaviour>();
    list.add(AutoSleepBehaviour.SLEEP_IF_BUS_IS_IDLE);
    list.add(AutoSleepBehaviour.DO_NOT_ENTER_SLEEP_MODE);
    return list;
  }
  public static AutoSleepBehaviour getDefault() {
    return AutoSleepBehaviour.DO_NOT_ENTER_SLEEP_MODE;
  }
  public static AutoSleepBehaviour parseValue(String value) {
    if(value == null) {
      return AutoSleepBehaviour.getDefault();
    }
    if(value.equals(AutoSleepBehaviour.SLEEP_IF_BUS_IS_IDLE.getValueAsString())) {
      return AutoSleepBehaviour.SLEEP_IF_BUS_IS_IDLE;
    }
    if(value.equals(AutoSleepBehaviour.DO_NOT_ENTER_SLEEP_MODE.getValueAsString())) {
      return AutoSleepBehaviour.DO_NOT_ENTER_SLEEP_MODE;
    }
    return AutoSleepBehaviour.getDefault();
  }

  public String getName() {
    return this.myName;
  }
  public String getValueAsString() {
    return "" + this.myValue;
  }
  public int getValue() {
    return this.myValue;
  }
}
