package mcp250xx;

/*Generated by MPS Feb 12, 2006 3:12:55 PM */


import java.util.List;
import java.util.LinkedList;

public enum BusOffRecoveryBehaviour {
  RECOVER_TO_LISTEN_ONLY_MODE("MCP2502X/5X will recover into Listen-only mode from bus off", 1),
  RECOVER_TO_NORMAL_MODE("MCP2502X/5X will recover into Normal mode from bus-off", 0);

  public String myName;
  public int myValue;

 BusOffRecoveryBehaviour(String name, int value) {
    this.myName = name;
    this.myValue = value;
  }

  public static List<BusOffRecoveryBehaviour> getConstants() {
    List<BusOffRecoveryBehaviour> list = new LinkedList<BusOffRecoveryBehaviour>();
    list.add(BusOffRecoveryBehaviour.RECOVER_TO_LISTEN_ONLY_MODE);
    list.add(BusOffRecoveryBehaviour.RECOVER_TO_NORMAL_MODE);
    return list;
  }
  public static BusOffRecoveryBehaviour getDefault() {
    return BusOffRecoveryBehaviour.RECOVER_TO_NORMAL_MODE;
  }
  public static BusOffRecoveryBehaviour parseValue(String value) {
    if(value == null) {
      return BusOffRecoveryBehaviour.getDefault();
    }
    if(value.equals(BusOffRecoveryBehaviour.RECOVER_TO_LISTEN_ONLY_MODE.getValueAsString())) {
      return BusOffRecoveryBehaviour.RECOVER_TO_LISTEN_ONLY_MODE;
    }
    if(value.equals(BusOffRecoveryBehaviour.RECOVER_TO_NORMAL_MODE.getValueAsString())) {
      return BusOffRecoveryBehaviour.RECOVER_TO_NORMAL_MODE;
    }
    return BusOffRecoveryBehaviour.getDefault();
  }

  public String getName() {
    return this.myName;
  }
  public String getValueAsString() {
    return "" + this.myValue;
  }
  public int getValue() {
    return this.myValue;
  }
}
