package mcp250xx;

/*Generated by MPS Feb 12, 2006 3:12:55 PM */


import java.util.List;
import java.util.LinkedList;

public enum BusSamplingMode {
  ONCE("Bus line is sampled once at the sample point", 0),
  THREE_TIMES("Bus line is sampled three times at the sample point", 1);

  public String myName;
  public int myValue;

 BusSamplingMode(String name, int value) {
    this.myName = name;
    this.myValue = value;
  }

  public static List<BusSamplingMode> getConstants() {
    List<BusSamplingMode> list = new LinkedList<BusSamplingMode>();
    list.add(BusSamplingMode.ONCE);
    list.add(BusSamplingMode.THREE_TIMES);
    return list;
  }
  public static BusSamplingMode getDefault() {
    return BusSamplingMode.ONCE;
  }
  public static BusSamplingMode parseValue(String value) {
    if(value == null) {
      return BusSamplingMode.getDefault();
    }
    if(value.equals(BusSamplingMode.ONCE.getValueAsString())) {
      return BusSamplingMode.ONCE;
    }
    if(value.equals(BusSamplingMode.THREE_TIMES.getValueAsString())) {
      return BusSamplingMode.THREE_TIMES;
    }
    return BusSamplingMode.getDefault();
  }

  public String getName() {
    return this.myName;
  }
  public String getValueAsString() {
    return "" + this.myValue;
  }
  public int getValue() {
    return this.myValue;
  }
}
