package mcp250xx;

/*Generated by MPS Feb 12, 2006 3:12:53 PM */


import jetbrains.mps.core.NamedConcept;
import jetbrains.mps.smodel.SModel;

public class CANPhysicalSettings extends NamedConcept {
  public static String WAKEUP_FILTER_ENABLED = "wakeupFilterEnabled";
  public static String SYNCHRONIZATION_JUMP_WITH = "synchronizationJumpWith";
  public static String BAUD_RATE_PRESCALER = "baudRatePrescaler";
  public static String PHASE_BUFFER_SEGMENT1_LENGTH = "phaseBufferSegment1Length";
  public static String PHASE_BUFFER_SEGMENT2_LENGTH = "phaseBufferSegment2Length";
  public static String PROPAGATION_SEGMENT_LENGTH = "propagationSegmentLength";
  public static String MODE = "mode";
  public static String PHASE_SEG2_LENGTH_DETERMINATION = "phaseSeg2LengthDetermination";
  public static String SCHEDULED_TRANSMISSION_SETTINGS = "scheduledTransmissionSettings";
  public static String RECEIVE_MASK = "receiveMask";
  public static String RECEIVE_FILTER0 = "receiveFilter0";
  public static String RECEIVE_FILTER1 = "receiveFilter1";
  public static String TRANSMIT_BUFFER0 = "transmitBuffer0";
  public static String TRANSMIT_BUFFER1 = "transmitBuffer1";
  public static String TRANSMIT_BUFFER2 = "transmitBuffer2";

  public CANPhysicalSettings(SModel model) {
    super(model);
  }

  public static CANPhysicalSettings newInstance(SModel model) {
    return new CANPhysicalSettings(model);
  }

  public boolean getWakeupFilterEnabled() {
    return this.getBooleanProperty(CANPhysicalSettings.WAKEUP_FILTER_ENABLED);
  }
  public void setWakeupFilterEnabled(boolean value) {
    this.setBooleanProperty(CANPhysicalSettings.WAKEUP_FILTER_ENABLED, value);
  }
  public int getSynchronizationJumpWith() {
    return this.getIntegerProperty(CANPhysicalSettings.SYNCHRONIZATION_JUMP_WITH);
  }
  public void setSynchronizationJumpWith(int value) {
    this.setIntegerProperty(CANPhysicalSettings.SYNCHRONIZATION_JUMP_WITH, value);
  }
  public int getBaudRatePrescaler() {
    return this.getIntegerProperty(CANPhysicalSettings.BAUD_RATE_PRESCALER);
  }
  public void setBaudRatePrescaler(int value) {
    this.setIntegerProperty(CANPhysicalSettings.BAUD_RATE_PRESCALER, value);
  }
  public int getPhaseBufferSegment1Length() {
    return this.getIntegerProperty(CANPhysicalSettings.PHASE_BUFFER_SEGMENT1_LENGTH);
  }
  public void setPhaseBufferSegment1Length(int value) {
    this.setIntegerProperty(CANPhysicalSettings.PHASE_BUFFER_SEGMENT1_LENGTH, value);
  }
  public int getPhaseBufferSegment2Length() {
    return this.getIntegerProperty(CANPhysicalSettings.PHASE_BUFFER_SEGMENT2_LENGTH);
  }
  public void setPhaseBufferSegment2Length(int value) {
    this.setIntegerProperty(CANPhysicalSettings.PHASE_BUFFER_SEGMENT2_LENGTH, value);
  }
  public int getPropagationSegmentLength() {
    return this.getIntegerProperty(CANPhysicalSettings.PROPAGATION_SEGMENT_LENGTH);
  }
  public void setPropagationSegmentLength(int value) {
    this.setIntegerProperty(CANPhysicalSettings.PROPAGATION_SEGMENT_LENGTH, value);
  }
  public BusSamplingMode getMode() {
    String value = super.getProperty(CANPhysicalSettings.MODE);
    return BusSamplingMode.parseValue(value);
  }
  public void setMode(BusSamplingMode value) {
    super.setProperty(CANPhysicalSettings.MODE, value.getValueAsString());
  }
  public PhaseSeg2LengthDetermination getPhaseSeg2LengthDetermination() {
    String value = super.getProperty(CANPhysicalSettings.PHASE_SEG2_LENGTH_DETERMINATION);
    return PhaseSeg2LengthDetermination.parseValue(value);
  }
  public void setPhaseSeg2LengthDetermination(PhaseSeg2LengthDetermination value) {
    super.setProperty(CANPhysicalSettings.PHASE_SEG2_LENGTH_DETERMINATION, value.getValueAsString());
  }
  public ScheduledTransmissionSettings getScheduledTransmissionSettings() {
    return (ScheduledTransmissionSettings)this.getChild(CANPhysicalSettings.SCHEDULED_TRANSMISSION_SETTINGS);
  }
  public void setScheduledTransmissionSettings(ScheduledTransmissionSettings node) {
    super.setChild(CANPhysicalSettings.SCHEDULED_TRANSMISSION_SETTINGS, node);
  }
  public CanIdentifierHolder getReceiveMask() {
    return (CanIdentifierHolder)this.getChild(CANPhysicalSettings.RECEIVE_MASK);
  }
  public void setReceiveMask(CanIdentifierHolder node) {
    super.setChild(CANPhysicalSettings.RECEIVE_MASK, node);
  }
  public CanIdentifierHolder getReceiveFilter0() {
    return (CanIdentifierHolder)this.getChild(CANPhysicalSettings.RECEIVE_FILTER0);
  }
  public void setReceiveFilter0(CanIdentifierHolder node) {
    super.setChild(CANPhysicalSettings.RECEIVE_FILTER0, node);
  }
  public CanIdentifierHolder getReceiveFilter1() {
    return (CanIdentifierHolder)this.getChild(CANPhysicalSettings.RECEIVE_FILTER1);
  }
  public void setReceiveFilter1(CanIdentifierHolder node) {
    super.setChild(CANPhysicalSettings.RECEIVE_FILTER1, node);
  }
  public TransmitBuffer getTransmitBuffer0() {
    return (TransmitBuffer)this.getChild(CANPhysicalSettings.TRANSMIT_BUFFER0);
  }
  public void setTransmitBuffer0(TransmitBuffer node) {
    super.setChild(CANPhysicalSettings.TRANSMIT_BUFFER0, node);
  }
  public TransmitBuffer getTransmitBuffer1() {
    return (TransmitBuffer)this.getChild(CANPhysicalSettings.TRANSMIT_BUFFER1);
  }
  public void setTransmitBuffer1(TransmitBuffer node) {
    super.setChild(CANPhysicalSettings.TRANSMIT_BUFFER1, node);
  }
  public TransmitBuffer getTransmitBuffer2() {
    return (TransmitBuffer)this.getChild(CANPhysicalSettings.TRANSMIT_BUFFER2);
  }
  public void setTransmitBuffer2(TransmitBuffer node) {
    super.setChild(CANPhysicalSettings.TRANSMIT_BUFFER2, node);
  }
}
