package mcp250xx;

/*Generated by MPS Feb 12, 2006 3:12:56 PM */


import java.util.List;
import java.util.LinkedList;

public enum ClockOutPrescaler {
  DIVIDE_BY_1("Fosc/1", 0),
  DIVIDE_BY_2("Fosc/2", 1),
  DIVIDE_BY_4("Fosc/4", 2),
  DIVIDE_BY_8("Fosc/8", 3);

  public String myName;
  public int myValue;

 ClockOutPrescaler(String name, int value) {
    this.myName = name;
    this.myValue = value;
  }

  public static List<ClockOutPrescaler> getConstants() {
    List<ClockOutPrescaler> list = new LinkedList<ClockOutPrescaler>();
    list.add(ClockOutPrescaler.DIVIDE_BY_1);
    list.add(ClockOutPrescaler.DIVIDE_BY_2);
    list.add(ClockOutPrescaler.DIVIDE_BY_4);
    list.add(ClockOutPrescaler.DIVIDE_BY_8);
    return list;
  }
  public static ClockOutPrescaler getDefault() {
    return ClockOutPrescaler.DIVIDE_BY_8;
  }
  public static ClockOutPrescaler parseValue(String value) {
    if(value == null) {
      return ClockOutPrescaler.getDefault();
    }
    if(value.equals(ClockOutPrescaler.DIVIDE_BY_1.getValueAsString())) {
      return ClockOutPrescaler.DIVIDE_BY_1;
    }
    if(value.equals(ClockOutPrescaler.DIVIDE_BY_2.getValueAsString())) {
      return ClockOutPrescaler.DIVIDE_BY_2;
    }
    if(value.equals(ClockOutPrescaler.DIVIDE_BY_4.getValueAsString())) {
      return ClockOutPrescaler.DIVIDE_BY_4;
    }
    if(value.equals(ClockOutPrescaler.DIVIDE_BY_8.getValueAsString())) {
      return ClockOutPrescaler.DIVIDE_BY_8;
    }
    return ClockOutPrescaler.getDefault();
  }

  public String getName() {
    return this.myName;
  }
  public String getValueAsString() {
    return "" + this.myValue;
  }
  public int getValue() {
    return this.myValue;
  }
}
