package mcp250xx;

/*Generated by MPS Feb 12, 2006 3:12:58 PM */


import java.util.List;
import java.util.LinkedList;

public enum DigitalInputChangeBehaviour {
  DO_NOT_TRANSMIT("Transition on the pin does not generate a message", 0),
  TRANSMIT_IF_LOW_TO_HIGH("Low-to-High transition on the pin generates a message", 2),
  TRANSMIT_IF_HIGH_TO_LOW("High-to-Low transition on the pin generates a message", 3);

  public String myName;
  public int myValue;

 DigitalInputChangeBehaviour(String name, int value) {
    this.myName = name;
    this.myValue = value;
  }

  public static List<DigitalInputChangeBehaviour> getConstants() {
    List<DigitalInputChangeBehaviour> list = new LinkedList<DigitalInputChangeBehaviour>();
    list.add(DigitalInputChangeBehaviour.DO_NOT_TRANSMIT);
    list.add(DigitalInputChangeBehaviour.TRANSMIT_IF_LOW_TO_HIGH);
    list.add(DigitalInputChangeBehaviour.TRANSMIT_IF_HIGH_TO_LOW);
    return list;
  }
  public static DigitalInputChangeBehaviour getDefault() {
    return DigitalInputChangeBehaviour.DO_NOT_TRANSMIT;
  }
  public static DigitalInputChangeBehaviour parseValue(String value) {
    if(value == null) {
      return DigitalInputChangeBehaviour.getDefault();
    }
    if(value.equals(DigitalInputChangeBehaviour.DO_NOT_TRANSMIT.getValueAsString())) {
      return DigitalInputChangeBehaviour.DO_NOT_TRANSMIT;
    }
    if(value.equals(DigitalInputChangeBehaviour.TRANSMIT_IF_LOW_TO_HIGH.getValueAsString())) {
      return DigitalInputChangeBehaviour.TRANSMIT_IF_LOW_TO_HIGH;
    }
    if(value.equals(DigitalInputChangeBehaviour.TRANSMIT_IF_HIGH_TO_LOW.getValueAsString())) {
      return DigitalInputChangeBehaviour.TRANSMIT_IF_HIGH_TO_LOW;
    }
    return DigitalInputChangeBehaviour.getDefault();
  }

  public String getName() {
    return this.myName;
  }
  public String getValueAsString() {
    return "" + this.myValue;
  }
  public int getValue() {
    return this.myValue;
  }
}
