package mcp250xx;

/*Generated by MPS Feb 12, 2006 3:12:58 PM */


import java.util.List;
import java.util.LinkedList;

public enum DigitalSignal {
  LOW("Low", 0),
  HIGH("High", 1);

  public String myName;
  public int myValue;

 DigitalSignal(String name, int value) {
    this.myName = name;
    this.myValue = value;
  }

  public static List<DigitalSignal> getConstants() {
    List<DigitalSignal> list = new LinkedList<DigitalSignal>();
    list.add(DigitalSignal.LOW);
    list.add(DigitalSignal.HIGH);
    return list;
  }
  public static DigitalSignal getDefault() {
    return DigitalSignal.LOW;
  }
  public static DigitalSignal parseValue(String value) {
    if(value == null) {
      return DigitalSignal.getDefault();
    }
    if(value.equals(DigitalSignal.LOW.getValueAsString())) {
      return DigitalSignal.LOW;
    }
    if(value.equals(DigitalSignal.HIGH.getValueAsString())) {
      return DigitalSignal.HIGH;
    }
    return DigitalSignal.getDefault();
  }

  public String getName() {
    return this.myName;
  }
  public String getValueAsString() {
    return "" + this.myValue;
  }
  public int getValue() {
    return this.myValue;
  }
}
