package mcp250xx;

/*Generated by MPS Feb 12, 2006 3:12:55 PM */


import java.util.List;
import java.util.LinkedList;

public enum ErrorConditionBehaviour {
  SEND_ERROR_MESSAGE("Will send message if error counter(s) go high enough", 1),
  DONT_SEND_ERROR_MESSAGE("Will NOT send message regardless of error counter values", 0);

  public String myName;
  public int myValue;

 ErrorConditionBehaviour(String name, int value) {
    this.myName = name;
    this.myValue = value;
  }

  public static List<ErrorConditionBehaviour> getConstants() {
    List<ErrorConditionBehaviour> list = new LinkedList<ErrorConditionBehaviour>();
    list.add(ErrorConditionBehaviour.SEND_ERROR_MESSAGE);
    list.add(ErrorConditionBehaviour.DONT_SEND_ERROR_MESSAGE);
    return list;
  }
  public static ErrorConditionBehaviour getDefault() {
    return ErrorConditionBehaviour.DONT_SEND_ERROR_MESSAGE;
  }
  public static ErrorConditionBehaviour parseValue(String value) {
    if(value == null) {
      return ErrorConditionBehaviour.getDefault();
    }
    if(value.equals(ErrorConditionBehaviour.SEND_ERROR_MESSAGE.getValueAsString())) {
      return ErrorConditionBehaviour.SEND_ERROR_MESSAGE;
    }
    if(value.equals(ErrorConditionBehaviour.DONT_SEND_ERROR_MESSAGE.getValueAsString())) {
      return ErrorConditionBehaviour.DONT_SEND_ERROR_MESSAGE;
    }
    return ErrorConditionBehaviour.getDefault();
  }

  public String getName() {
    return this.myName;
  }
  public String getValueAsString() {
    return "" + this.myValue;
  }
  public int getValue() {
    return this.myValue;
  }
}
