package mcp250xx;

/*Generated by MPS Feb 12, 2006 3:12:56 PM */


import java.util.List;
import java.util.LinkedList;

public enum IOPinMode {
  INPUT("Digital input", "0"),
  OUTPUT("Digital output", "1"),
  ANALOG_INPUT("Analog input", "2"),
  PWM_OUTPUT("PWM output", "3"),
  NEGATIVE_V_REF("Negative voltage reference", "4"),
  POSITIVE_V_REF("Positive voltage reference", "5"),
  CLOCK_OUTPUT("Clock output", "6"),
  RESET("External reset", "7");

  public String myName;
  public String myValue;

 IOPinMode(String name, String value) {
    this.myName = name;
    this.myValue = value;
  }

  public static List<IOPinMode> getConstants() {
    List<IOPinMode> list = new LinkedList<IOPinMode>();
    list.add(IOPinMode.INPUT);
    list.add(IOPinMode.OUTPUT);
    list.add(IOPinMode.ANALOG_INPUT);
    list.add(IOPinMode.PWM_OUTPUT);
    list.add(IOPinMode.NEGATIVE_V_REF);
    list.add(IOPinMode.POSITIVE_V_REF);
    list.add(IOPinMode.CLOCK_OUTPUT);
    list.add(IOPinMode.RESET);
    return list;
  }
  public static IOPinMode getDefault() {
    return IOPinMode.INPUT;
  }
  public static IOPinMode parseValue(String value) {
    if(value == null) {
      return IOPinMode.getDefault();
    }
    if(value.equals(IOPinMode.INPUT.getValueAsString())) {
      return IOPinMode.INPUT;
    }
    if(value.equals(IOPinMode.OUTPUT.getValueAsString())) {
      return IOPinMode.OUTPUT;
    }
    if(value.equals(IOPinMode.ANALOG_INPUT.getValueAsString())) {
      return IOPinMode.ANALOG_INPUT;
    }
    if(value.equals(IOPinMode.PWM_OUTPUT.getValueAsString())) {
      return IOPinMode.PWM_OUTPUT;
    }
    if(value.equals(IOPinMode.NEGATIVE_V_REF.getValueAsString())) {
      return IOPinMode.NEGATIVE_V_REF;
    }
    if(value.equals(IOPinMode.POSITIVE_V_REF.getValueAsString())) {
      return IOPinMode.POSITIVE_V_REF;
    }
    if(value.equals(IOPinMode.CLOCK_OUTPUT.getValueAsString())) {
      return IOPinMode.CLOCK_OUTPUT;
    }
    if(value.equals(IOPinMode.RESET.getValueAsString())) {
      return IOPinMode.RESET;
    }
    return IOPinMode.getDefault();
  }

  public String getName() {
    return this.myName;
  }
  public String getValueAsString() {
    return this.myValue;
  }
  public String getValue() {
    return this.myValue;
  }
}
