package mcp250xx;

/*Generated by MPS Feb 12, 2006 3:12:56 PM */


import java.util.List;
import java.util.LinkedList;

public enum InformationRequestMessageType {
  DATA_FRAME("RTR is NOT used for IRM (Data Frame)", 1),
  REMOTE_FRAME("RTR is used for IRM (Remote Frame)", 0);

  public String myName;
  public int myValue;

 InformationRequestMessageType(String name, int value) {
    this.myName = name;
    this.myValue = value;
  }

  public static List<InformationRequestMessageType> getConstants() {
    List<InformationRequestMessageType> list = new LinkedList<InformationRequestMessageType>();
    list.add(InformationRequestMessageType.DATA_FRAME);
    list.add(InformationRequestMessageType.REMOTE_FRAME);
    return list;
  }
  public static InformationRequestMessageType getDefault() {
    return InformationRequestMessageType.REMOTE_FRAME;
  }
  public static InformationRequestMessageType parseValue(String value) {
    if(value == null) {
      return InformationRequestMessageType.getDefault();
    }
    if(value.equals(InformationRequestMessageType.DATA_FRAME.getValueAsString())) {
      return InformationRequestMessageType.DATA_FRAME;
    }
    if(value.equals(InformationRequestMessageType.REMOTE_FRAME.getValueAsString())) {
      return InformationRequestMessageType.REMOTE_FRAME;
    }
    return InformationRequestMessageType.getDefault();
  }

  public String getName() {
    return this.myName;
  }
  public String getValueAsString() {
    return "" + this.myValue;
  }
  public int getValue() {
    return this.myValue;
  }
}
