package mcp250xx;

/*Generated by MPS Feb 12, 2006 3:12:55 PM */


import java.util.List;
import java.util.LinkedList;

public enum Mode {
  LISTEN_ONLY("Listen-only mode", 1),
  NORMAL("Normal mode", 0);

  public String myName;
  public int myValue;

 Mode(String name, int value) {
    this.myName = name;
    this.myValue = value;
  }

  public static List<Mode> getConstants() {
    List<Mode> list = new LinkedList<Mode>();
    list.add(Mode.LISTEN_ONLY);
    list.add(Mode.NORMAL);
    return list;
  }
  public static Mode getDefault() {
    return Mode.NORMAL;
  }
  public static Mode parseValue(String value) {
    if(value == null) {
      return Mode.getDefault();
    }
    if(value.equals(Mode.LISTEN_ONLY.getValueAsString())) {
      return Mode.LISTEN_ONLY;
    }
    if(value.equals(Mode.NORMAL.getValueAsString())) {
      return Mode.NORMAL;
    }
    return Mode.getDefault();
  }

  public String getName() {
    return this.myName;
  }
  public String getValueAsString() {
    return "" + this.myValue;
  }
  public int getValue() {
    return this.myValue;
  }
}
