package mcp250xx;

/*Generated by MPS Feb 12, 2006 3:12:58 PM */


import java.util.List;
import java.util.LinkedList;

public enum PWMTimerPrescaler {
  DIVIDE_BY_1("1", 0),
  DIVIDE_BY_4("4", 1),
  DIVIDE_BY_16("16", 2);

  public String myName;
  public int myValue;

 PWMTimerPrescaler(String name, int value) {
    this.myName = name;
    this.myValue = value;
  }

  public static List<PWMTimerPrescaler> getConstants() {
    List<PWMTimerPrescaler> list = new LinkedList<PWMTimerPrescaler>();
    list.add(PWMTimerPrescaler.DIVIDE_BY_1);
    list.add(PWMTimerPrescaler.DIVIDE_BY_4);
    list.add(PWMTimerPrescaler.DIVIDE_BY_16);
    return list;
  }
  public static PWMTimerPrescaler getDefault() {
    return PWMTimerPrescaler.DIVIDE_BY_1;
  }
  public static PWMTimerPrescaler parseValue(String value) {
    if(value == null) {
      return PWMTimerPrescaler.getDefault();
    }
    if(value.equals(PWMTimerPrescaler.DIVIDE_BY_1.getValueAsString())) {
      return PWMTimerPrescaler.DIVIDE_BY_1;
    }
    if(value.equals(PWMTimerPrescaler.DIVIDE_BY_4.getValueAsString())) {
      return PWMTimerPrescaler.DIVIDE_BY_4;
    }
    if(value.equals(PWMTimerPrescaler.DIVIDE_BY_16.getValueAsString())) {
      return PWMTimerPrescaler.DIVIDE_BY_16;
    }
    return PWMTimerPrescaler.getDefault();
  }

  public String getName() {
    return this.myName;
  }
  public String getValueAsString() {
    return "" + this.myValue;
  }
  public int getValue() {
    return this.myValue;
  }
}
