package mcp250xx;

/*Generated by MPS Feb 12, 2006 3:12:56 PM */


import java.util.List;
import java.util.LinkedList;

public enum PowerUpCompletionBehaviour {
  Z("Enters 'Normal' mode after completing self-configuration during power-up sequence", 1),
  ZZ("Enables 'Listen-only' mode after completing self-configuration", 0);

  public String myName;
  public int myValue;

 PowerUpCompletionBehaviour(String name, int value) {
    this.myName = name;
    this.myValue = value;
  }

  public static List<PowerUpCompletionBehaviour> getConstants() {
    List<PowerUpCompletionBehaviour> list = new LinkedList<PowerUpCompletionBehaviour>();
    list.add(PowerUpCompletionBehaviour.Z);
    list.add(PowerUpCompletionBehaviour.ZZ);
    return list;
  }
  public static PowerUpCompletionBehaviour getDefault() {
    return PowerUpCompletionBehaviour.ZZ;
  }
  public static PowerUpCompletionBehaviour parseValue(String value) {
    if(value == null) {
      return PowerUpCompletionBehaviour.getDefault();
    }
    if(value.equals(PowerUpCompletionBehaviour.Z.getValueAsString())) {
      return PowerUpCompletionBehaviour.Z;
    }
    if(value.equals(PowerUpCompletionBehaviour.ZZ.getValueAsString())) {
      return PowerUpCompletionBehaviour.ZZ;
    }
    return PowerUpCompletionBehaviour.getDefault();
  }

  public String getName() {
    return this.myName;
  }
  public String getValueAsString() {
    return "" + this.myValue;
  }
  public int getValue() {
    return this.myValue;
  }
}
