package mcp250xx;

/*Generated by MPS Feb 12, 2006 3:12:56 PM */


import java.util.List;
import java.util.LinkedList;

public enum PowerUpSleepBehaviour {
  SLEEP_DURING_LISTEN_ONLY_POWER_UP("Enable SLEEP when in Listen-only mode during power-up sequence", 1),
  NO_SLEEP_DURING_LISTEN_ONLY_POWER_UP("Disable SLEEP when in Listen-only mode during power-up sequence", 0);

  public String myName;
  public int myValue;

 PowerUpSleepBehaviour(String name, int value) {
    this.myName = name;
    this.myValue = value;
  }

  public static List<PowerUpSleepBehaviour> getConstants() {
    List<PowerUpSleepBehaviour> list = new LinkedList<PowerUpSleepBehaviour>();
    list.add(PowerUpSleepBehaviour.SLEEP_DURING_LISTEN_ONLY_POWER_UP);
    list.add(PowerUpSleepBehaviour.NO_SLEEP_DURING_LISTEN_ONLY_POWER_UP);
    return list;
  }
  public static PowerUpSleepBehaviour getDefault() {
    return PowerUpSleepBehaviour.NO_SLEEP_DURING_LISTEN_ONLY_POWER_UP;
  }
  public static PowerUpSleepBehaviour parseValue(String value) {
    if(value == null) {
      return PowerUpSleepBehaviour.getDefault();
    }
    if(value.equals(PowerUpSleepBehaviour.SLEEP_DURING_LISTEN_ONLY_POWER_UP.getValueAsString())) {
      return PowerUpSleepBehaviour.SLEEP_DURING_LISTEN_ONLY_POWER_UP;
    }
    if(value.equals(PowerUpSleepBehaviour.NO_SLEEP_DURING_LISTEN_ONLY_POWER_UP.getValueAsString())) {
      return PowerUpSleepBehaviour.NO_SLEEP_DURING_LISTEN_ONLY_POWER_UP;
    }
    return PowerUpSleepBehaviour.getDefault();
  }

  public String getName() {
    return this.myName;
  }
  public String getValueAsString() {
    return "" + this.myValue;
  }
  public int getValue() {
    return this.myValue;
  }
}
