package mcp250xx;

/*Generated by MPS Feb 12, 2006 3:12:55 PM */


import java.util.List;
import java.util.LinkedList;

public enum ScheduledTransmissionMessageType {
  SEND_AD_REGS("Send Transmit ID 0 (TXID0) with the 'Read A/D Regs' data (DLC = 8)", 0),
  SEND_NO_DATA("Send Transmit ID 0 (TXID0) with no data (DLC = 0)", 1);

  public String myName;
  public int myValue;

 ScheduledTransmissionMessageType(String name, int value) {
    this.myName = name;
    this.myValue = value;
  }

  public static List<ScheduledTransmissionMessageType> getConstants() {
    List<ScheduledTransmissionMessageType> list = new LinkedList<ScheduledTransmissionMessageType>();
    list.add(ScheduledTransmissionMessageType.SEND_AD_REGS);
    list.add(ScheduledTransmissionMessageType.SEND_NO_DATA);
    return list;
  }
  public static ScheduledTransmissionMessageType getDefault() {
    return ScheduledTransmissionMessageType.SEND_NO_DATA;
  }
  public static ScheduledTransmissionMessageType parseValue(String value) {
    if(value == null) {
      return ScheduledTransmissionMessageType.getDefault();
    }
    if(value.equals(ScheduledTransmissionMessageType.SEND_AD_REGS.getValueAsString())) {
      return ScheduledTransmissionMessageType.SEND_AD_REGS;
    }
    if(value.equals(ScheduledTransmissionMessageType.SEND_NO_DATA.getValueAsString())) {
      return ScheduledTransmissionMessageType.SEND_NO_DATA;
    }
    return ScheduledTransmissionMessageType.getDefault();
  }

  public String getName() {
    return this.myName;
  }
  public String getValueAsString() {
    return "" + this.myValue;
  }
  public int getValue() {
    return this.myValue;
  }
}
