package mcp250xx.editor;

import jetbrains.mps.nodeEditor.EditorContext;
import jetbrains.mps.nodeEditor.ModelAccessor;
import jetbrains.mps.smodel.SNode;
import jetbrains.mps.smodel.SModelUtil;
import mcp250xx.IOPin;
import mcp250xx.UserData;

import javax.swing.*;

public class Queries {
    public static ModelAccessor createModelAccessor_data (SNode node) {
        System.out.println ("node = " + node);
        return new UserDataModelAccessor ((UserData) node);
    }

    public static boolean semanticNodeCondition_condition (SNode node) {
        System.out.println ("condition invoked on " + node);
        UserData userData = (UserData) node;
        String data = userData.getData ();
        return data != null && data.length () == 16;
    }

    public static JComponent cellJComponent_swing (SNode sourceNode, EditorContext context) {
        return new JComboBox (new String[]{"a", "b"});
    }

    public static boolean semanticNodeCondition_isOutputPin (SNode node) {

        //SModelUtil.getBooleanConceptProperty(node, )

        //IOPin pin = (IOPin) node;
        //return pin.getBooleanConceptProperty ("outputPin");

        return false;
    }

    public static ModelAccessor createModelAccessor_getIOPinNumber (SNode node) {
        System.out.println ("requested new ModelAccessor for node = " + node);
        return new IOPinNumberModelAccessor (node);
    }

}

class UserDataModelAccessor implements ModelAccessor {
    private UserData node;

    public UserDataModelAccessor (UserData node) {
        this.node = node;
    }

    public String getText () {
        return node.getData ();
    }

    public void setText (String text) {
        node.setData (text);
    }

    public boolean isValidText (String string) {
        return !(string == null || string.length () != 16);
    }
}

class IOPinNumberModelAccessor implements ModelAccessor {
    private SNode node;

    public IOPinNumberModelAccessor (SNode node) {
        this.node = node;
    }

    public String getText () {
        //System.out.println ("requested getText for " + node);
        //int integerConceptProperty = node.getIntegerConceptProperty ("number");
        //System.out.println ("integerConceptProperty = " + integerConceptProperty);
        //return String.valueOf (integerConceptProperty);

        return "N/A";
    }

    public void setText (String text) {

    }

    public boolean isValidText (String string) {
        return true;
    }
}

