package CSharp3.structure;

/*Generated by MPS */

import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.LinkedList;

public enum AttributeTarget {
  field("field", "field"),
  event("event", "event"),
  method("method", "method"),
  parameter("param", "parameter"),
  property("property", "property"),
  return_value("return", "return value"),
  type("type", "type");

  private String myName;
  private String myValue;

  AttributeTarget(String name, String value) {
    this.myName = name;
    this.myValue = value;
  }

  public String getName() {
    return this.myName;
  }

  public String getValueAsString() {
    return this.myValue;
  }

  public String getValue() {
    return this.myValue;
  }


  public static List<AttributeTarget> getConstants() {
    List<AttributeTarget> list = ListSequence.fromList(new LinkedList<AttributeTarget>());
    ListSequence.fromList(list).addElement(AttributeTarget.field);
    ListSequence.fromList(list).addElement(AttributeTarget.event);
    ListSequence.fromList(list).addElement(AttributeTarget.method);
    ListSequence.fromList(list).addElement(AttributeTarget.parameter);
    ListSequence.fromList(list).addElement(AttributeTarget.property);
    ListSequence.fromList(list).addElement(AttributeTarget.return_value);
    ListSequence.fromList(list).addElement(AttributeTarget.type);
    return list;
  }

  public static AttributeTarget getDefault() {
    return null;
  }

  public static AttributeTarget parseValue(String value) {
    if (value == null) {
      return AttributeTarget.getDefault();
    }
    if (value.equals(AttributeTarget.field.getValueAsString())) {
      return AttributeTarget.field;
    }
    if (value.equals(AttributeTarget.event.getValueAsString())) {
      return AttributeTarget.event;
    }
    if (value.equals(AttributeTarget.method.getValueAsString())) {
      return AttributeTarget.method;
    }
    if (value.equals(AttributeTarget.parameter.getValueAsString())) {
      return AttributeTarget.parameter;
    }
    if (value.equals(AttributeTarget.property.getValueAsString())) {
      return AttributeTarget.property;
    }
    if (value.equals(AttributeTarget.return_value.getValueAsString())) {
      return AttributeTarget.return_value;
    }
    if (value.equals(AttributeTarget.type.getValueAsString())) {
      return AttributeTarget.type;
    }
    return AttributeTarget.getDefault();
  }

}
