package JavaSrcLang.generator.template.main.util;

/*Generated by MPS */

import simplelogger.SimpleLogger;
import jetbrains.mps.util.MacrosFactory;
import java.io.File;
import java.io.FileReader;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.LogManager;

public class CopySourcesHelper {

  public static void copySourcesToSolution() {

    SimpleLogger.logClass = "CopySourcesHelper";
    SimpleLogger.debug("Sources are bing copied...");

    String mpsProjectDir = MacrosFactory.getGlobal().expandPath("${java_src_project}");
    String sourceDir = mpsProjectDir + "/SourcesDir/src/com/mypackage/mysubpackage/";
    String destinationDir = mpsProjectDir + "/solutions/CopiedJavaSources/copied/com/mypackage/mysubpackage/";

    // Copy the original files to the destination directory 
    File sourceFolder = new File(sourceDir);
    for (File srcFile : sourceFolder.listFiles()) {
      File destFile = new File(destinationDir + srcFile.getName());
      copyFileContents(srcFile, destFile);
    }

    SimpleLogger.debug("Copying of sources are finished.");
  }

  private static void copyFileContents(File srcFile, File destFile) {
    FileReader fileReader = null;
    BufferedReader bufferedReader = null;
    FileWriter fileWriter = null;
    BufferedWriter bufferedWriter = null;
    try {
      fileReader = new FileReader(srcFile);
      bufferedReader = new BufferedReader(fileReader);

      fileWriter = new FileWriter(destFile);
      bufferedWriter = new BufferedWriter(fileWriter);

      String lineRead;
      while ((lineRead = bufferedReader.readLine()) != null) {
        bufferedWriter.write(lineRead + "\n");
      }
      bufferedWriter.flush();
    } catch (IOException ioException) {
      if (LOG.isEnabledFor(Level.ERROR)) {
        LOG.error("", ioException);
      }
    } finally {
      if (bufferedReader != null) {
        try {
          bufferedReader.close();
        } catch (IOException e) {
          if (LOG.isEnabledFor(Level.ERROR)) {
            LOG.error("", e);
          }
        }
      }
      if (bufferedWriter != null) {
        try {
          bufferedWriter.close();
        } catch (IOException e) {
          if (LOG.isEnabledFor(Level.ERROR)) {
            LOG.error("", e);
          }
        }
      }
      if (fileReader != null) {
        try {
          fileReader.close();
        } catch (IOException e) {
          if (LOG.isEnabledFor(Level.ERROR)) {
            LOG.error("", e);
          }
        }
      }
      if (fileWriter != null) {
        try {
          fileWriter.close();
        } catch (IOException e) {
          if (LOG.isEnabledFor(Level.ERROR)) {
            LOG.error("", e);
          }
        }
      }
    }
  }


  protected static Logger LOG = LogManager.getLogger(CopySourcesHelper.class);
}
