package simplelogger;

/*Generated by MPS */

import jetbrains.mps.util.MacrosFactory;
import java.util.Date;
import java.text.SimpleDateFormat;
import java.io.PrintWriter;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

public class SimpleLogger {
  private static final String logsDirectory = MacrosFactory.getGlobal().expandPath("${java_src_project}") + "/logs/mylogs.log";

  public static String logClass = "NullClass";

  public static void error(String msg) {
    int level = 1;
    writeToFile(msg, level);
  }
  public static void debug(String msg) {
    int level = 2;
    writeToFile(msg, level);
  }
  public static void info(String msg) {
    int level = 3;
    writeToFile(msg, level);
  }

  private static void writeToFile(String message, int level) {
    Date date = new Date();
    SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");

    String finalMessage = dateFormat.format(date) + " | ";

    switch (level) {
      case 1:
        finalMessage += "ERROR";
        break;
      case 2:
        finalMessage += "DEBUG";
        break;
      case 3:
        finalMessage += "INFO";
        break;
      default:
        finalMessage += "DEBUG";
    }

    finalMessage += " | " + logClass + " | " + message;

    PrintWriter out = null;
    try {
      out = new PrintWriter(new BufferedWriter(new FileWriter(logsDirectory, true)));
      out.println(finalMessage);
    } catch (IOException e) {
    } finally {
      if (out != null) {
        out.close();
      }
    }

  }
}
